<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwformat:Transforms/wwhelp_context.xsl" />


 <xsl:key name="wwproject-formatconfigurations-by-targetid" match="wwproject:FormatConfiguration" use="@TargetID" />
 <xsl:key name="wwproject-group-by-groupid" match="wwproject:Group" use="@GroupID" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/wwhelp_context.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/wwhelp_context.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarProgressProjectGroupsAndMergeStart" select="wwprogress:Start(count($VarProjectGroups) + 1)" />

   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarProgressProjectGroupStart" select="wwprogress:Start(1)" />

    <!-- Determine group output directory path -->
    <!--                                       -->
    <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarProjectGroup/@Name)" />
    <xsl:variable name="VarPath" select="wwfilesystem:Combine($VarGroupOutputDirectoryPath, 'wwhelp/books.htm')" />

    <!-- Transform -->
    <!--           -->
    <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $VarProjectGroup/@ChangeID, $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
    <xsl:if test="not($VarUpToDate)">
     <xsl:variable name="VarResultAsXML">
      <xsl:call-template name="BooksHTML">
       <xsl:with-param name="ParamProjectGroup" select="$VarProjectGroup" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
     <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'xhtml', '1.0', 'yes', 'no', 'no', '-//W3C//DTD XHTML 1.0 Transitional//EN', 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd')" />
    </xsl:if>

    <!-- Report Files -->
    <!--              -->
    <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$VarProjectGroup/@ChangeID}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}" />

    <xsl:variable name="VarProgressProjectGroupEnd" select="wwprogress:End()" />
   </xsl:for-each>

   <!-- Merge -->
   <!--       -->
   <xsl:variable name="VarProgressMergeStart" select="wwprogress:Start(1)" />
   <xsl:if test="count($VarProjectGroups) &gt; 1">
    <xsl:for-each select="$GlobalProject[1]">
     <xsl:variable name="VarFormatConfiguration" select="key('wwproject-formatconfigurations-by-targetid', wwprojext:GetFormatID())[1]" />
     <xsl:variable name="VarMergeSettings" select="$VarFormatConfiguration/wwproject:MergeSettings" />

     <xsl:variable name="VarMergePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), 'wwhelp/books.htm')" />

     <!-- Call template -->
     <!--               -->
     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarMergePath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups)), '', '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResultAsXML">
       <xsl:call-template name="MergeBooksHTML">
        <xsl:with-param name="ParamMergeSettings" select="$VarMergeSettings" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
      <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarMergePath, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'xhtml', '1.0', 'yes', 'no', 'no', '-//W3C//DTD XHTML 1.0 Transitional//EN', 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd')" />
     </xsl:if>

     <wwfiles:File path="{$VarMergePath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarMergePath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups))}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}" />
    </xsl:for-each>
   </xsl:if>
   <xsl:variable name="VarProgressMergeEnd" select="wwprogress:End()" />

   <xsl:variable name="VarProgressProjectGroupsAndMergeEnd" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="BooksHTML">
  <xsl:param name="ParamProjectGroup" />

  <xsl:variable name="VarGroupTitle">
   <xsl:call-template name="WWHelpTitle">
    <xsl:with-param name="ParamProject" select="$GlobalProject" />
    <xsl:with-param name="ParamGroupID" select="$ParamProjectGroup/@GroupID" />
   </xsl:call-template>
  </xsl:variable>

  <html:html>
   <html:head>
    <html:title>Web Search</html:title>
   </html:head>
   <html:body>
    <html:h2>Web Search</html:h2>
 
    <html:div>
     <!-- Force single line -->
     <!--                   -->
     <wwexsldoc:NoBreak />

     <html:a href="../wwhdata/files.htm" title="{$VarGroupTitle}">
      <xsl:value-of select="$VarGroupTitle" />
     </html:a>
    </html:div>
   </html:body>
  </html:html>
 </xsl:template>


 <xsl:template name="MergeBooksHTML">
  <xsl:param name="ParamMergeSettings" />

  <html:html>
   <html:head>
    <html:title>Web Search</html:title>
   </html:head>
   <html:body>
    <html:h2>Web Search</html:h2>
 
    <xsl:apply-templates select="$ParamMergeSettings" mode="wwmode:mergebooks" />
   </html:body>
  </html:html>
 </xsl:template>


 <xsl:template match="wwproject:TOC" mode="wwmode:mergebooks">
  <xsl:param name="ParamTOC" select="." />

  <xsl:variable name="VarIncludeBookGroup">
   <xsl:call-template name="VerifyBookGroup">
    <xsl:with-param name="ParamContext" select="$ParamTOC" />
   </xsl:call-template>
  </xsl:variable>

  <xsl:if test="$VarIncludeBookGroup = 'true'">
   <xsl:apply-templates select="$ParamTOC/*" mode="wwmode:mergebooks" />
  </xsl:if>
 </xsl:template>


 <xsl:template match="wwproject:MergeGroup" mode="wwmode:mergebooks">
  <xsl:param name="ParamMergeGroup" select="." />

  <xsl:variable name="VarIncludeGroup">
   <xsl:call-template name="VerifyGroup">
    <xsl:with-param name="ParamMergeGroup" select="$ParamMergeGroup" />
   </xsl:call-template>
  </xsl:variable>

  <xsl:if test="$VarIncludeGroup = 'true'">
   <xsl:for-each select="$GlobalProject[1]">
    <html:div>
     <!-- Force single line -->
     <!--                   -->
     <wwexsldoc:NoBreak />

     <xsl:variable name="VarGroupName" select="wwprojext:GetGroupName($ParamMergeGroup/@GroupID)" />
     <html:a href="../{wwuri:EscapeData(wwprojext:GetGroupName($ParamMergeGroup/@GroupID))}/wwhdata/files.htm" title="{$VarGroupName}">
      <xsl:value-of select="$VarGroupName" />
     </html:a>
    </html:div>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>
 
 <xsl:template name="VerifyGroup">
  <xsl:param name="ParamMergeGroup" />
  
  <xsl:for-each select="$GlobalProject[1]">
   <xsl:variable name="VarGroup" select="key('wwproject-group-by-groupid', $ParamMergeGroup/@GroupID)" />
   <xsl:variable name="VarGroupDocuments" select="$VarGroup/descendant::wwproject:Document" />
   
   <xsl:value-of select="count($VarGroupDocuments[1]) &gt; 0" />
  </xsl:for-each>
 </xsl:template>
 
 <xsl:template name="VerifyBookGroup">
  <xsl:param name="ParamContext" select="." />

  <xsl:variable name="VarBooksAsXML">
   <xsl:apply-templates select="$ParamContext/*" mode="wwmode:mergebooks" />
  </xsl:variable>
   
  <xsl:value-of select="count(msxsl:node-set($VarBooksAsXML)/*[1]) &gt; 0" />
 </xsl:template>
</xsl:stylesheet>
